{DelphiSim                                        }
{v.1.05                                           }
{Roeland van der Spek                             }
{spekw@acm.org                                    }
{(C) 1997                                         }
{Example: machines a transporter and orderlists   }


{
  In this example conatainers are transported beween a filling machine and
  an emtying machine.

  A transporter waits until an empty conatainer is available, it transports
  this container to the filling machine, where the container will be filled.
  Here, the transporter waits until there is an empty container available.
  When this is the case, the container is transported to the emptying station
  where it is emptyed. Here the cycle starts again...

  This example makes use of Orderlists. There are two of them, each represents
  a container depot. FullStock contains the full containters, and EmptyStock
  contains the empty containers.

  When the filling machine is ready filling up the container, it is placed
  on the FullStock orderlist. The same applies for the emptying machine, this
  one places its empty containers on the EmtyStock.

  When the transporter removes the containers from a stock, it does so with
  a order to continue command. If there is nothing in stock, it will go passive
  until there is.
}


unit Examp3;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Random,Machine,Orderlist, delphiSim, StdCtrls;

type
  TForm1 = class(TForm)
    mysim: TSimulation;
    Button1: TButton;
    Label2: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    LFillActive: TLabel;
    LEmptyActive: TLabel;
    LTranspIdle: TLabel;
    LTranspActive: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure mysimSimInit(eventlist: TEventList);
    procedure Button1Click(Sender: TObject);
    procedure mysimSimEnd;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  TContainer = class(TObject);     {the container}

  {
    A transporter carries a container. Further, it contains two state
    variables: WaitingForEmptyContainer which indicates the transporter
    is currently waiting for an empty container and WaitingForFullContainer
    which indicates the transporter is waiting for a full container
  }
  TTransporter = class(TSimProcess)
    Container:TContainer;
    ActiveTime:double;
    IdleTime:Double;
    WaitingForEmptyContainer:Boolean;
    WaitingForFullContainer:Boolean;
    procedure body; override;        {dont forget to override the body}
    Constructor Create(S:TSimulation;t:Double;n:String);
  end;

  TFiller = class(TMachine)                   {definition for the filler machine}
     procedure continue(O:Tobject); override; {dont forget to override the continue mehtod}
  end;

  TEmptyer = class(TMachine)                  {definition for the emptyer machine}
     Procedure Continue(O:TObject); override; {dont forget to override the continue mehtod}
  end;

  TEmptyStock = Class(TOrderList)             {Definition of the EmptyStock orderlist}
    Procedure Continue(O:TObject); Override;  {dont forget to override the continue mehtod}
  end;

  TFullStock = class(TOrderlist)              {Definition of the FullStock ORderlist}
    procedure Continue(O:Tobject); override;  {dont forget to override the continue mehtod}
  end;

  {
     At the start of the simulation, there are no Container objects in the system,
     Therefore, we introduce two generators, the full generator generates the
     number of full containers, present in the system at starttime, and places them
     on the FullStock Orderlist. The second does the same for the empty containers
     and the EmptyStock OrderList
  }

  TFullGenerator = class(TSimProcess)
     procedure body; override;
  end;

  TEmptyGenerator = class(TSimProcess)
     Procedure body; override;
  end;


var
  Form1: TForm1;
  EmptyStock:TemptyStock;
  FullStock:TFullStock;
  Transporter:TTransporter;
  Filler:TFiller;
  Emptyer:TEmptyer;
  FillTime:TExponential;           {The stream that generates filling times}
  EmptyTime:TExponential;          {The stream that generates emptying times}
  TransportTime:TUniform;          {The stream that generates the transport time}
  MyStream:TrandomStream;          {the random genarator that we will use}
  FullGenerator:TFullGenerator;
  EmptyGenerator:TEmptyGenerator;

implementation

procedure TFullGenerator.body;
var i:Integer;
    P:TContainer;
begin
  for i:=1 to 1 do                    {we generate one full container}
  begin
    P:=TContainer.create;
    FullStock.waitTobeOrdered(P);     {and place it on the FullStock OrderList}
  end;
end;

Procedure TEmptyGenerator.body;
var i:Integer;
    P:TContainer;
begin
  For i:=1 to 1 do                    {we generate one empty container}
  begin
    P:=TContainer.create;
    EmptyStock.WaitToBeOrdered(P);    {and place it on the EmptyStock Orderlist}
  end;
end;

{
  creates the transport object
}
Constructor TTransporter.create(S:TSimulation;t:Double;n:String);
begin
  inherited create(S,t,n);
  WaitingForEmptyContainer:=false;
  WaitingForFullContainer:=false;
  ActiveTime:=0;
  IdleTime:=0;
end;

Procedure TTransporter.Body;
var x:Integer;
    mark:Double;
begin
  while not false do
  begin
    mark:=Simtime;
    x:=EmptyStock.OrderToContinue(1,true);     {Try to pick up a container}
    if x = 0 then
    begin
      WaitingForEmptyContainer:=true;          {if unsucessfull then wait....}
      Passivate;
    end;
    WaitingForEmptyContainer:=False;
    IdleTime:=IdleTime+Simtime-Mark;

    Mark:=Simtime;
    Holdfor(TransportTime.draw);               {transport to the filling station}
    ActiveTime:=ActiveTime+Simtime-mark;

    Filler.process(Container,FillTime.draw);   {Let the filler process (fill) the container}

    mark:=Simtime;
    x:=FullStock.OrderToContinue(1,true);      {Try to pick up a full container}
    if x = 0 then
    begin
      WaitingForFullContainer:=true;           {if unsucessfull then wait.....}
      passivate;
    end;
    waitingForFullContainer:=false;
    IdleTime:=IdleTime + Simtime-Mark;

    mark:=Simtime;
    HoldFor(TransportTime.draw);               {transport full container back to to the emptying station}
    ActiveTime:=ActiveTime+Simtime - Mark;
    Emptyer.process(container,EmptyTime.draw); {Let the Emptyer process (empty) the full container}
  end;
end;

{
  When a container is removed from the orderlist it is handled by the
  continue mehtod. A container is either ordered to continue directly
  by the transporter or it was continued by backorder
}

Procedure TFullStock.continue(O:TObject);
begin
  Transporter.Container:=O as TContainer;     {become the Transporters, current container}
  if Transporter.WaitingForFullContainer then {if the transporter has placed a backorder and }
     transporter.activate;                    {is currently waiting then Re-activate the transporter}
end;

Procedure TEmptyStock.continue(O:Tobject);
begin
  Transporter.Container:=O as TContainer;       {see previous description}
  if Transporter.WaitingForEmptyContainer then
     Transporter.activate;
end;

Procedure TFiller.Continue(O:TObject);
begin
  FullStock.WaitToBeOrdered(O);          {if a container is filled, it is placed on the FullStock OrderList}
end;

Procedure TEmptyer.Continue(O:TObject);
begin
  EmptyStock.WaitToBeOrdered(O);         {If a container is emptied, it is placed on the EmptyStock Orderlist}
end;


{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  MyStream:=TRandomStream.create(134,523);      {initalize the random streams when the programs start}
  TransportTime:=Tuniform.create(6,8,Mystream);
  FillTime:=TExponential.create(30,Mystream);
  EmptyTime:=TExponential.create(35,MyStream);
end;

{
  At the SimInit Event, all processes must be created
}
procedure TForm1.mysimSimInit(eventlist: TEventList);
begin
  EmptyStock:=TEmptyStock.create;                                     {create the orderlists}
  FullStock:=TFullStock.create;
  Filler:=TFiller.create(mysim,'the Filler');                         {create the filler machine}
  Emptyer:=TEmptyer.create(Mysim,'The Empyter');                      {create the emptyer Machine}
  Transporter:=TTransporter.create(mysim,0,'The Transporter');        {Create the transporter}
  EmptyGenerator:=TEmptyGenerator.create(mysim,0,'Creator of empty containers');  {Create the Container generators}
  FullGenerator:=TFullGenerator.create(Mysim,0,'Creator of full container')
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  button1.enabled:=false;
  mysim.startSimulation   {start the simulation with a touch on the button}
end;

procedure TForm1.mysimSimEnd;
begin
  LFillActive.caption := format('%f',[Filler.TimeActive]);
  LEmptyActive.caption := Format('%f',[Emptyer.TimeActive]);
  LTranspActive.caption:= format('%f',[Transporter.ActiveTime]);
  LTranspIdle.caption:=format('%f',[transporter.idleTime]);
  button1.enabled:=true;

  Filler.free;
  emptyer.free;
  transporter.free;
  FullGenerator.free;
  EmptyGenerator.free;
end;

end.
